package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats de la gnration d'une Empreinte
 */
public class SortieResultatEmpreinteFichier extends SortieResultatTriple {
	
	/**
	 * Libell de l'empreinte
	 */
	private JLabel libelleEmpreinte;
	
	/**
	 * Texte de l'empreinte
	 */
	private JTextArea texteEmpreinte;
	
	/**
	 * Ascenseur du texte de l'empreinte
	 */
	private JScrollPane scrollEmpreinte;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatEmpreinteFichier(FenetrePrincipale fenetre) {

		super(fenetre);

    	libelleEmpreinte = new JLabel("Empreinte : ");
        texteEmpreinte = new JTextArea();
        scrollEmpreinte = new JScrollPane(texteEmpreinte,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        texteEmpreinte.setLineWrap(true);
        texteEmpreinte.setWrapStyleWord(true);
        texteEmpreinte.setEditable(false);
        scrollEmpreinte.setBackground(Color.white);   
    	
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {
    	
    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    		
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	
	    	// Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        if(texteEmpreinte != null)
	        	texteEmpreinte.setText("");
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortie, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortie, 1, 1, 1, 4);
	        // Ligne 2
	        g.ajoute(libelleOperation2, EcranUtil.styleLibelleSortie, 2, 0, 1, 1);
	        g.ajoute(texteOperation2, EcranUtil.styleTexteSortie, 2, 1, 1, 4);
	        // Ligne 3
	        g.ajoute(libelleCodeRetour2, EcranUtil.styleLibelleSortie, 3, 0, 1, 1);
	        g.ajoute(texteCodeRetour2, EcranUtil.styleTexteSortie, 3, 1, 1, 4);
	        // Ligne 4
	        g.ajoute(libelleOperation3, EcranUtil.styleLibelleSortie, 4, 0, 1, 1);
	        g.ajoute(texteOperation3, EcranUtil.styleTexteSortie, 4, 1, 1, 4);
	        // Ligne 5
	        g.ajoute(libelleCodeRetour3, EcranUtil.styleLibelleSortie, 5, 0, 1, 1);
	        g.ajoute(texteCodeRetour3, EcranUtil.styleTexteSortie, 5, 1, 1, 4);
	        // Ligne 6
	        g.ajoute(libelleEmpreinte, EcranUtil.styleLibelleLigneEntiere, 6, 0, 1, 5);
	        // Ligne 7
	        g.ajoute(scrollEmpreinte, EcranUtil.styleScrollInfos, 7, 0, 1, 5);
	        // Ligne 8
	        if(barreStatut != null)
	        	barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 8, 0, 1, 6);
	        
    	}

    }

	/**
	 * Affecte le texte de l'empreinte
	 * @param empreinte Le texte de l'empreinte
	 */
	public void setEmpreinte(String empreinte) {
		if(empreinte != null && texteEmpreinte != null)
			texteEmpreinte.setText(empreinte);
	}

}
